--  
require( "scripts/game/deftasks.lua" );
require( "scripts/game/deftime.lua" );
GameObject = {
    Params = {
        ID="car1";
        width=2;
        height=4;
        --health=3200;
        RandomTasks=0;
        GridData= { 
            1, 1,
            1, 1,
            1, 1,
            1, 1
        };
        timerTask=-1;       -- do not change this parameter ( )
    };
    ActivePoints = { 
        fixed1 = { 
                   { {}, 2,2,0,  0,  2,2,0 };
                   }; 
        fixed2 = { 
                   { {}, 1,-1,0,  0,  1,-1,0 };
                   }; 
    };
    Objects = {};
    -- list of all tasks for an object
    Tasks = {
        fixed1 = { FuncName="Fixed1TaskExecute", sleeping={0}, not_need_action=1,timer=1,time_tick=100 };
        --fixed2 = { FuncName="Fixed2TaskExecute", sleeping={0}, skill_up = 0 };
        --   
        breakage = { FuncName="BreakageTaskExecute", sleeping={0}, hand_add=1, timer=2,time_tick=1000 };
    };
    -- list of all triggers for an object
    Triggers = { 
        BreakageTrigger = {FuncName="BreakageTriggerFunc", NotRunWhen={"fixed1","breakage"}, timer={ 8 }, first_timer={ 5 }, amount=1, cur_value=0 }
    };
    --tasks to be performed after an object is created
    InitActiveTasks = {};
    --tasks an object is waiting ofr after it is created
    InitExpectedTasks = {};
    products = 1;
    max_products = 4;
    isNormal = 1;
};
function GameObject:Get()
    return self;
end


--        
function OnInit()
    aObj = GameObject:Get();   
    if( not aObj.Params.MaxHealth )then
        aObj.Params.MaxHealth = aObj.Params.health;
    end;
    aObj.isNormal = 1;
end
    

function GetParams()
    aObj = GameObject:Get();   
    return aObj.Params;
end

-- perform Task EATING over external object and return true if task is completed
function Fixed1TaskExecute()
    aObject = GameObject:Get();
    local prod = GetKoefProduct();
    CPP_SetAnimState("normal_"..prod);
    CPP_PlaySound("car_fix",0);
    CPP_RecursiveRun("fixed_machine",0);
    aObject.isNormal = 1;
    return 0;
end
-- perform Task EATING over external object and return true if task is completed
function Fixed2TaskExecute()
    aObject = GameObject:Get();
    local prod = GetKoefProduct();
    CPP_SetAnimState("normal_"..prod);
    CPP_RecursiveRun("fixed_machine",0);
    aObject.isNormal = 1;
    return 0;
end

function BreakageTriggerFunc()
    aObject = GameObject:Get();
    local aTrigger = aObject.Triggers.BreakageTrigger;
    --         
    if (aTrigger.amount <= 0) then return; end
    --      
    if (aTrigger.under_task == 1) then 
        if (aTrigger.no_run_stop == 1) then return; end
        return; 
    end
    
    if ((not aTrigger.cur_value) or (aTrigger.cur_value == 0)) then
        aTrigger.cur_value = GetTriggerTimerRand(aTrigger);
        return;
    end
    
    aTrigger.cur_value = aTrigger.cur_value - 1;
    if (aTrigger.cur_value <= 0) then
        aTrigger.cur_value = 0;
        --      
        aTrigger.under_task = 1;
        aTrigger.no_run_stop = 0;
        local res = CPP_DoTaskIfPossible("breakage","");
        local prod = GetKoefProduct();
        CPP_SetAnimState("breakage_"..prod);
        CPP_PlaySound("car_break",0);
        aObject.isNormal = 0;
        if (res == 0) then
            -- 
            BreakageTaskExecute();
        end
    end
end 

--  
function BreakageTaskExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then tTask = aObject.Tasks.breakage.timer; end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        CPP_RecursiveRun("breakage_machine",0);
        CPP_AddExpectedTasks("fixed1");
        CPP_WantSelect(1);
        return 0;
    end
    return 1;
end

function GetKoefProduct()
    aObject = GameObject:Get();
    if (aObject.products < 1) then 
        aObject.products = 1; 
    else
        if (aObject.products > aObject.max_products) then 
            aObject.products = aObject.max_products;
        end
    end
    return aObject.products;
end

function IncProduct()
    aObject = GameObject:Get();
    if (aObject.products + 1 <= aObject.max_products) then 
        aObject.products = aObject.products + 1;
    end
    CPP_SetAnimState("normal_"..aObject.products);
end
